dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/ballroom", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 4, 175, 400, "assets/images/table/ballroom", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 4, 400, 400, "assets/images/table/ballroom", "assets/images/food/item_mark1", "B" );


useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 250;

-- Group 1
guest = LManager.GenGuest(uncle);
guest.matchType = male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 20;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2

guest = LManager.GenGuest(female04);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 8, 30000);


-- Group 3

guest = LManager.GenGuest(female01);
guest.matchType = male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female03;
guest.percentRequestCoffee = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 48000);

-- Group 4

guest = LManager.GenGuest(male02);
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 11, 65000);


-- Group 5

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 12, 75000);

-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 15, 90000);


-- Group 6

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 17, 110000);


-- Group 7

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female01;
guest.percentRequestCoffee = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 20, 130000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("speakerDelay", 100000); 
LManager:SetLevelSetting ("speakerChance", 60);


LManager:SetLevelSetting ("bridesmaidsDelay", 75000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Set up the Level Settings
LManager:SetLevelNumber(2,9);
LManager:SetLevelScores(8000, 12000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );